	

	library ieee;
	use ieee.std_logic_1164.all;
	use ieee.std_logic_arith.all;
	use ieee.std_logic_unsigned.all;
	use ieee.numeric_std.all;
	
	entity Lights is
	port( 
		LED: out std_logic_vector ( 8 downto 0 );
		DPSw: in std_logic_vector ( 7 downto 0 );
		SW2: in std_logic ;
		SW3: in std_logic ;
		XCLK: in std_logic ;
		SCE: in std_logic ;
		SCK: in std_logic ;
		SDI: in std_logic ;
		SDO: out std_logic  );
	end;
	
	architecture A of Lights is
	signal TLED: std_logic_vector(7 downto 0);
	signal TSW:	std_logic;
	signal LEDBuf:	std_logic_vector(7 downto 0);
	signal ISCE: std_logic;
	signal ISCK: std_logic;
	signal ISDI:	std_logic;
	
	begin
	RegSCE:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ISCE <= SCE;
		end if;
	end process;
	
	RegSCK:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ISCK <= SCK;
		end if;
	end process;
	
	RegSDI:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ISDI <= SDI;
		end if;
	end process;
	-- synchronize the inbound signals
		
	TSW <= DPsw(0) and DPsw(1) and DPsw(2) and DPsw(3)
		 and DPsw(4) and DPsw(5) and DPsw(6) and DPsw(7)
		 and SW2 and SW3;
	 
	LED(8) <= not TSW;
	-- dummy statament
	
	RegLedBuf:process(ISCE,ISCK) begin
		if(rising_edge(ISCK) and (ISCE = '0')) then
			LEDBuf(7 downto 0) <=  LEDBuf(6 downto 0) & ISDI;
		end if;
	end process;	
	-- shifts SDI into the register
	
	RegBufTxf:process(ISCE) begin
		if(rising_edge(ISCE)) then
			TLED <= LEDBuf;
		end if;
	end process;	
	-- copies the SPI shift register data to the LED buffer
	
	SDO <= XCLK;
	LED(7 downto 0) <= not(TLED);
	end A;
	


