	library ieee;
	use ieee.std_logic_1164.all;
	use ieee.std_logic_arith.all;
	use ieee.std_logic_unsigned.all;
	use ieee.numeric_std.all;
	
	entity Lights is
	
	port( 
		LED: out std_logic_vector ( 8 downto 0 );
		DPSw: in std_logic_vector ( 7 downto 0 );
		SW2: in std_logic ;
		SW3: in std_logic ;
		XCLK: in std_logic ;
		SCE: in std_logic ;
		SCK: in std_logic ;
		SDI: in std_logic ;
		SDO: out std_logic;
		Tout: out std_logic
	  );
	
	end;
	
	architecture A of Lights is
	
	component Cnt16_ld
	    port (Clock: in  std_logic; Clk_En: in  std_logic; 
	        Aclr: in  std_logic; Load: in  std_logic; 
	        LData: in  std_logic_vector(15 downto 0); 
	        Q: out  std_logic_vector(15 downto 0));
	end component;
	
	signal TLED:	std_logic_vector(7 downto 0);
	signal TSW:	std_logic;
	signal SPIBuf:	std_logic_vector(15 downto 0);
	signal SPIOutBuf:std_logic_vector(15 downto 0);
	signal ISCE: 	std_logic;
	signal ISCK: 	std_logic;
	signal ISDI:	std_logic;
	signal Tcnt:	std_logic_vector(15 downto 0);
	signal Fcnt:	std_logic_vector(15 downto 0);
	signal ZeroP:	std_logic;
	signal ZeroQ:	std_logic;
	signal Sqwave: 	std_logic;
	signal SDOtemp: std_logic;
	signal CEP:	std_logic;
	signal CEQ:	std_logic;
	signal CEQQ:	std_logic;
	signal CKP:	std_logic;
	signal CKQ:	std_logic;
	signal CKQQ:	std_logic;
	
	begin
	
	
	RegSCE:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ISCE <= SCE;
		end if;
	end process;
	
	RegSCK:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ISCK <= SCK;
		end if;
	end process;
	
	RegSDI:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ISDI <= SDI;
		end if;
	end process;
	-- synchronize the inbound signals
	
	
	RegSCE:process(XCLK) begin
		if(rising_edge(XCLK)) then
			CEP <= ISCE;
		end if;
	end process;
	
	CEQ <= CEP and not(ISCE);
	
	RegSCE:process(XCLK) begin
		if(rising_edge(XCLK)) then
			CEQQ <= CEQ;
		end if;
	end process;
	---- CE low edge detector
	
	RegSCK:process(XCLK) begin
		if(rising_edge(XCLK)) then
			CKP <= ISCK;
		end if;
	end process;
	
	CKQ <= not(CKP) and ISCK;
	
	RegSCK:process(XCLK) begin
		if(rising_edge(XCLK)) then
			CKQQ <= CKQ;
	end if;
	end process;
	
	---- CK high edge detector
	 
	
	TSW <= DPsw(0) and DPsw(1) and DPsw(2) and DPsw(3)
		 and DPsw(4) and DPsw(5) and DPsw(6) and DPsw(7)
		 and SW2;
	 
	LED(8) <= not TSW;
	-- dummy statament
	
	
	
	RegLedBuf:process(ISCE,ISCK) begin
		if(rising_edge(ISCK) and (ISCE = '0')) then
			SPIBuf(15 downto 0) <=  SPIBuf(14 downto 0) & ISDI ;
		end if;
	end process;	
	-- shifts SDI into the register
	
	RegBufTxf:process(ISCE) begin
		if(rising_edge(ISCE)) then
			Fcnt <= SPIBuf;
		end if;
	end process;	
	-- copies the SPI shift register data to the LED buffer
	
	Count : Cnt16_ld
		port map (
			Clock=>XCLK,
			Clk_En=>'1',
			Aclr=>'0',
			Load=>ZeroQ,
			LData(15 downto 0)=>Fcnt, 
	        	Q(15 downto 0)=>Tcnt
			);
	
	
	ZeroP <= not(Tcnt(15)) and not(Tcnt(14)) and not(Tcnt(13)) 
		and not(Tcnt(12)) and not(Tcnt(11)) and not(Tcnt(10))
		and not(Tcnt(9)) and not(Tcnt(8)) and not(Tcnt(7))
		and not(Tcnt(6)) and not(Tcnt(5)) and not(Tcnt(4)) 
		and not(Tcnt(3)) and not(Tcnt(2)) and not(Tcnt(1))
		and not(Tcnt(0)); 
	
	
	RegZero:process(XCLK) begin
		if(rising_edge(XCLK)) then
			ZeroQ <= ZeroP;
		end if;
	end process;
	
	--SDO <= ZeroQ;
	-- end of count, reload pulse
	
	RegSqw:process(XCLK,ZeroQ) begin
		if(rising_edge(XCLK) and ZeroQ = '1') then
			if(Sqwave = '0') then
				Sqwave <= '1';
			else
				Sqwave <= '0';
			end if;
		end if;
	end process;
	
	Tout <= Sqwave; 
	-- square wave output 1/2 rate of reload pulse
	
	
	LedSel:process(SW3) begin
		if(SW3 = '0') then
			TLED <= Fcnt(7 downto 0);
		else
			TLED <= Fcnt(15 downto 8);
		end if;
	end process;
	-- shows upper and lower value of timer preload
	
	
	RegOutBufTxf:process(ISCE) begin
		
		if(rising_edge(XCLK)) then
			if (CEQQ = '1') then
				SPIOutBuf <= "10100101" & DPsw;
			elsif (CKQQ = '1' and ISCE = '0') then
				SPIOutBuf(15 downto 0) <= '0' & SPIOutBuf(15 downto 1);
			end if;	
		end if;
	end process;	
	
	SDO <= SPIOutBuf(0);
	-- copy register to SPIOutBuf on falling edge of 
	-- SCE and clock out on rising edge of SCK
	
	
	LED(7 downto 0) <= not(TLED(7 downto 0));
		
	end A;
	
